--Settings you can change
local SSC_BORDER_SIZE = 4;
local SSC_ROWS = 6;
local SSC_COLUMNS = 7;
local P1_selectionX, P1_selectionY = 2,2; --Where you want the cursor to start.
local P2_selectionX, P2_selectionY = 4,2;
local bWidth, bHeight = 69,81;
--Required so getImagePath and getSoundPath returns the correct path to the images
local ScreenName = "ScreenSelectCharacter";

--I bet this wastes enormous amounts of memory
--[[
The number next to the name is their place in Characters 10x4.
It starts at 0 (Sion) and ends at 30 (Neko & Mech).
31 and 32 are unused characters, 38 & 39 are Random and None
Note that these are internal names, make sure you localize them in the [Characters] section!
]]
local characters = {
	[10] = {"Aozaki",20},
	[01] = {"ArimaMiyako", 8},
	[02] = {"HisuiAndKohaku", 4},
	[03] = {"SchoolAkiha", 24},
	
	[20] = {"TohnoShiki",7},
	[11] = {"Ciel",2},
	[12] = {"TohnoAkiha", 3},
	[13] = {"Satsuki", 16},
	[14] = {"KohaAndMech", 29},
	
	[30] = {"ArchetypeEarth",27},
	[21] = {"SionEltnam", 0},
	[22] = {"Arcueid", 1},
	[23] = {"Len", 17},
	[24] = {"Hisui", 5},
	
	[40] = {"NanayaShiki",15},
	[31] = {"Riesbyfe", 26},
	[32] = {"PoweredCiel", 18},
	[33] = {"RyougiShiki", 28},
	[34] = {"NekoArcN", 19},
	--[35] = {"Random", 38}, --Unimplemented
	
	[50] = {"KishimaKouma",22},
	[41] = {"SionTatari", 11},
	[42] = {"RedArcueid", 12},
	[43] = {"WhiteLen", 21},
	[44] = {"Kohaku", 6},
	
	[51] = {"Wallachia", 9},
	[52] = {"AkihaVermillion", 13},
	[53] = {"Chaos", 10},
	[54] = {"NekoAndMech", 30},
	
	[61] = {"MichaelRoa",26},
	[62] = {"MechHisui", 14},
	[63] = {"NekoArcChaos", 23}
	--Unused: GAkiha (G-Akiha), Dust (Dust of Osiris)
};


local boxFrameActor;

--Various precalculated variables to make things easy to position
local sqWidth = bWidth*SSC_COLUMNS+SSC_BORDER_SIZE*SSC_COLUMNS;
local sqHeight = bHeight*SSC_ROWS+SSC_BORDER_SIZE*SSC_ROWS;
local xPosition = SCREEN_CENTER_X-sqWidth/2+bWidth/2+SSC_BORDER_SIZE/2;
local yPosition = SCREEN_CENTER_Y-sqHeight/2+bHeight/2+SSC_BORDER_SIZE/2;

local t = Def.ActorFrame{

	LoadActor("Please Select Your Character")..{
		OnCommand=cmd(play);
	};
	
	--[[Def.Quad{
		InitCommand=cmd(Center;setsize,sqWidth,sqHeight;diffuse,Color("Red"));
	
	};]]
}

local boxFrame = Def.ActorFrame{
	InitCommand=function(self)
		self:x(xPosition);
		self:y(yPosition);
	end;
	
	OnCommand=function(self)
		boxFrameActor = self;
	end;
};

for i = 0, SSC_ROWS-1 do
	for j = 0, SSC_COLUMNS-1 do
		local chrID = tonumber(j..i)
		boxFrame[#boxFrame+1] = Def.ActorFrame{
			InitCommand=cmd(xy,j*(bWidth+SSC_BORDER_SIZE),i*(bHeight+SSC_BORDER_SIZE));
			Name=j..","..i;
			
			--[[Def.Quad{
				InitCommand=cmd(setsize,bWidth,bHeight);
				OnCommand=function(self)
					if j%2 == 0 then
						if i%2 == 0 then
							self:diffuse(Color("HoloBlue"));
						else
							self:diffuse(Color("White"));
						end;
					else
						if i%2 ~= 0 then
							self:diffuse(Color("HoloBlue"));
						else
							self:diffuse(Color("White"));
						end;
					end;
				end;
			};
			
			LoadFont("Common Normal")..{
				InitCommand=cmd(diffuse,color("0,0,0,1"));
				Text=j..","..i;
			};]]
			
			--[[LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:y(20):diffuse(color("0,0,0,1"));
					if characters[chrID] then
						self:settext(characters[chrID][1])
					else
						self:settext("Missing")
					end
				end;
			};]]
			
			LoadActor("Characters 10x4")..{
				Name="CharacterIcon";
				InitCommand=function(self)
					self:animate(false):zoom(1.5)--[[:cropleft(.05):croptop(.05):cropbottom(.05):cropright(.05)]];
					self:rotationx(-90):rotationy(-90);
					if characters[chrID] then
						self:setstate(characters[chrID][2]);
					else
						--self:setstate(39) --Debug testing only
						self:visible(false);
					end;
				end;
				OnCommand=cmd(sleep,.01*chrID;linear,.2;rotationx,0;rotationy,0);
			
			};
			--[[Def.Sprite{
				InitCommand=function(self)
					self:Load("Characters 10x4.png");
					--self:Load(getImagePath("icon", chrID));
				end;
			}]]
		};
	end
end

t[#t+1] = boxFrame;

--Welcome to Hell!

local function getImagePath(prefix, chrID)
	--return THEME:GetCurrentThemeDirectory().."BGAnimations/"..ScreenName.." overlay/"..prefix.."_"..characters[chrID][1]..".png";
	return THEME:GetCurrentThemeDirectory().."Graphics/"..prefix.."_"..characters[chrID][1]..".png";
	--SCREENMAN:SystemMessage(s);
	--return s;
end;


--If both players are present, use these variables to wait
P1_isReady = false;
P2_isReady = false;

-- P1 side
--local oldP1_selectionX, oldP1_selectionY = P1_selectionX, P1_selectionY;
local P1_isSelectingDifficulty = false;

--[[local function getSoundPath(chrID)
	return THEME:GetCurrentThemeDirectory().."BGAnimations/"..ScreenName.." overlay/sound_"..characters[chrID][1]..".wav";
end;]]

local function updateSelection(self, muted, selectionX, selectionY)
	local chrID = tonumber(selectionX..selectionY)
	if not muted then
		SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
	end;
	self:GetChild("SelectionIcon"):stoptweening():xy(xPosition+selectionX*bWidth+selectionX*SSC_BORDER_SIZE,yPosition+selectionY*bHeight+selectionY*SSC_BORDER_SIZE):queuecommand("Pulse");	
	self:GetChild("icon"):stoptweening():xy(xPosition+selectionX*bWidth+selectionX*SSC_BORDER_SIZE,yPosition+selectionY*bHeight+selectionY*SSC_BORDER_SIZE):queuecommand("Pulse");	
	--boxFrameActor:GetChild(oldP1_selectionX..","..oldP1_selectionY):GetChild("CharacterIcon"):cropleft(.05):croptop(.05):cropbottom(.05):cropright(.05);
	boxFrameActor:GetChild(selectionX..","..selectionY):GetChild("CharacterIcon"):cropleft(0):croptop(0):cropbottom(0):cropright(0);

	self:GetChild("Name"):stoptweening():diffusealpha(0):settext(THEME:GetString("Characters",characters[chrID][1])--[[.." "..chrID]]):queuecommand("Anim");
	self:GetChild("Portrait"):stoptweening():diffusealpha(0):Load(getImagePath("portrait", chrID)):linear(0):queuecommand("Anim");
	self:GetChild("PortraitShadow"):stoptweening():diffusealpha(0):Load(getImagePath("portrait", chrID)):linear(0):queuecommand("Anim");
	--oldP1_selectionX, oldP1_selectionY = P1_selectionX, P1_selectionY;
end;


t[#t+1] = Def.ActorFrame{

	--[[Def.Quad{
		--Debug
		InitCommand=cmd(Center;setsize,bWidth,bHeight;diffuse,Color("Red"));	
	};]]
	OnCommand=function(self)
		--ScreenName = SCREENMAN:GetTopScreen():GetName();
		updateSelection(self, true, P1_selectionX, P1_selectionY);
		if not GAMESTATE:IsSideJoined(PLAYER_1) then
			self:visible(false);
		end;
	end;
	
	CodeMessageCommand=
	function(self, param)
		if param.PlayerNumber ~= PLAYER_1 or GAMESTATE:IsSideJoined(PLAYER_1) == false then return end;
		if P1_isSelectingDifficulty == false then
			if param.Name == "left" then
				if characters[tonumber((P1_selectionX-1)..P1_selectionY)] then
					P1_selectionX = P1_selectionX - 1;
					updateSelection(self, false, P1_selectionX, P1_selectionY);
				end;
			elseif param.Name == "right" then
				if characters[tonumber((P1_selectionX+1)..P1_selectionY)] then
					P1_selectionX = P1_selectionX + 1;
					updateSelection(self, false, P1_selectionX, P1_selectionY);
				end;
			elseif param.Name == "down" then
				if characters[tonumber(P1_selectionX..(P1_selectionY+1))] then
					P1_selectionY = P1_selectionY + 1;
					updateSelection(self, false, P1_selectionX, P1_selectionY);
				end;
			elseif param.Name == "up" then
				if characters[tonumber(P1_selectionX..(P1_selectionY-1))] then
					P1_selectionY = P1_selectionY - 1;
					updateSelection(self, false, P1_selectionX, P1_selectionY);
				end;
			elseif param.Name == "start" then
				--SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
				--SOUND:PlayOnce(getSoundPath(tonumber(P1_selectionX..P1_selectionY)));
				SOUND:PlayOnce(THEME:GetPathS("","accept"));
				self:GetChild("Portrait"):queuecommand("Selected");
				self:GetChild("DifficultySelect"):playcommand("Selected");
				--[[self:GetChild("BigDisk"):queuecommand("Selected");
				self:GetChild("SmallDisk"):queuecommand("Selected");
				self:GetChild("Difflabel"):queuecommand("Selected");
				self:GetChild("Diffinfo"):queuecommand("Selected");]]
				self:GetChild("Dim"):queuecommand("Selected");
				self:GetChild("SystemText"):queuecommand("Selected");
				P1_isSelectingDifficulty = true;
			elseif param.Name == "back" then
				SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
			end;
		else
			--MESSAGEMAN:Broadcast("DIfficultyInput", param);
			if param.Name == "back" then
				--[[self:GetChild("BigDisk"):queuecommand("Unselected");
				self:GetChild("SmallDisk"):queuecommand("Unselected");
				self:GetChild("Difflabel"):queuecommand("Unselected");
				self:GetChild("Diffinfo"):queuecommand("Unselected");]]
				self:GetChild("DifficultySelect"):playcommand("Unselected");
				self:GetChild("Dim"):queuecommand("Unselected");
				self:GetChild("SystemText"):queuecommand("Unselected");
				self:GetChild("PleaseWait"):playcommand("Unselected");
				P1_isSelectingDifficulty = false;
				P1_isReady = false;
			elseif param.Name == "up" then
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
				if MBSTATE:GetDifficulty(PLAYER_1) > 0 then
					MBSTATE:SetDifficulty(PLAYER_1, MBSTATE:GetDifficulty(PLAYER_1)-1)
				else
					MBSTATE:SetDifficulty(PLAYER_1, 4);
				end;
				MESSAGEMAN:Broadcast("DifficultyChanged", {Direction=-1,Player=0});
				--SCREENMAN:SystemMessage(_G.P1_info.Difficulty);
			elseif param.Name == "down" then
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
				if MBSTATE:GetDifficulty(PLAYER_1) < 4 then
					MBSTATE:SetDifficulty(PLAYER_1, MBSTATE:GetDifficulty(PLAYER_1)+1)
				else
					MBSTATE:SetDifficulty(PLAYER_1, 0);
				end;
				MESSAGEMAN:Broadcast("DifficultyChanged", {Direction=1, Player=0});
			elseif param.Name == "start" then
				if P1_isReady == false then
					SOUND:PlayOnce(THEME:GetPathS("","accept"));
					local chrID = tonumber(P1_selectionX..P1_selectionY)
					MBSTATE:SetCharacter(PLAYER_1,characters[chrID][1]);
					self:GetChild("DifficultySelect"):queuecommand("Finished");
					--If the other player is present, wait for them to select character and difficulty
					if GAMESTATE:IsSideJoined(PLAYER_2) then
						P1_isReady = true;
						--If the other player is ready then we can go to the next screen
						if P2_isReady then
							SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
						else
							self:GetChild("PleaseWait"):playcommand("Waiting");
						end;
					--No need to wait if there's no other player
					else
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
					end;
				end;
			end;
		end;
	end;
		
	--[[Def.Quad{
		Name="SelectionIcon";
		InitCommand=cmd(setsize,bWidth,bHeight;diffuse,color("#66ff66");queuecommand,"Pulse");
		PulseCommand=cmd(linear,1;diffusealpha,.2;linear,1;diffusealpha,1;queuecommand,"Pulse");
		--OnCommand=cmd(xy,boxFrameActor:GetChild("0,0"):GetX(),boxFrameActor:GetChild("0,0"):GetY());
		OnCommand=function(self)
			self:x(xPosition);
			self:y(yPosition);
		end;
	};]]
	LoadActor("P1Cursor")..{
		Name="SelectionIcon";
		InitCommand=cmd(zoom,1.5;SetAllStateDelays,0.05;);
		--[[OnCommand=function(self)
			self:x(xPosition);
			self:y(yPosition);
		end;]]
	};
	LoadActor("p1icon")..{
		Name="icon";
		InitCommand=cmd(zoom,1.5;glowshift;glow,Color("White"););
		--[[OnCommand=function(self)
			self:x(xPosition-12);
			self:y(yPosition+25);
		end;]]
	};
	
	Def.Sprite{
		Name="PortraitShadow";
		InitCommand=cmd(xy,SCREEN_WIDTH/4,SCREEN_CENTER_Y;zoom,.75;diffuse,color("0,0,0,0"));
		AnimCommand=cmd(x,0;diffusealpha,0;decelerate,.4;diffusealpha,.6;x,240;sleep,0;linear,.1;x,270);
	};
	
	Def.Quad{
		Name="Dim";
		InitCommand=cmd(setsize,SCREEN_WIDTH/4,SCREEN_HEIGHT;diffuse,Color("Black");faderight,.75;horizalign,left;xy,-(SCREEN_WIDTH/4),SCREEN_CENTER_Y);
		SelectedCommand=cmd(decelerate,.3;x,0);
		UnselectedCommand=cmd(decelerate,.3;x,-(SCREEN_WIDTH/4));
	};
	Def.Sprite{
		Name="Portrait";
		InitCommand=cmd(xy,SCREEN_WIDTH/4,SCREEN_CENTER_Y;zoom,.75);
		AnimCommand=cmd(x,0;diffusealpha,0;glow,Color("White");decelerate,.4;diffusealpha,1;x,240;glow,color("0,0,0,0"));
		SelectedCommand=cmd(glow,Color("White");linear,.5;glow,color("0,0,0,0"));
	};
	
	LoadActor("../DifficultySelect", PLAYER_1)..{
		Name="DifficultySelect";
	};
	
	Def.ActorFrame{
		Name="PleaseWait";
		InitCommand=cmd(visible,false;xy,SCREEN_WIDTH/4-100,SCREEN_CENTER_Y);
		WaitingCommand=cmd(visible,true);
		UnselectedCommand=cmd(visible,false);
		Def.Quad{
			InitCommand=cmd(setsize,220,50;diffuse,color("0,0,0,.8");fadeleft,.2;faderight,.2;);
		};
		LoadFont("Common Normal")..{
			Text=THEME:GetString("Common","PleaseWait");
		};
	};
	
	LoadFont("Dialogue Character Names")..{
		Name="Name";
		InitCommand=cmd(y,SCREEN_BOTTOM-75;diffusebottomedge,Color("Purple"));
		AnimCommand=cmd(x,0;decelerate,.5;diffusealpha,1;x,200);
	};
	
	LoadFont("System")..{
		Name="SystemText";
		Text=THEME:GetString("Common","PressStart");
		InitCommand=cmd(zoom,1.5;vertalign,top;xy,SCREEN_WIDTH*.75,5;shadowcolor,color("#061CE8");shadowlengthy,3;visible,not GAMESTATE:IsSideJoined(PLAYER_2));
		SelectedCommand=cmd(settext,THEME:GetString("Common","PleaseWait"));
		UnselectedCommand=cmd(settext,THEME:GetString("Common","PressStart"));
	};
};

--P2 side
local P2_isSelectingDifficulty = false;


t[#t+1] = Def.ActorFrame{

	--[[Def.Quad{
		--Debug
		InitCommand=cmd(Center;setsize,bWidth,bHeight;diffuse,Color("Red"));	
	};]]
	OnCommand=function(self)
		--ScreenName = SCREENMAN:GetTopScreen():GetName();
		updateSelection(self, true, P2_selectionX, P2_selectionY);
		if not GAMESTATE:IsSideJoined(PLAYER_2) then
			self:visible(false);
		end;
	end;
	
	CodeMessageCommand=
	function(self, param)
		if param.PlayerNumber ~= PLAYER_2 or GAMESTATE:IsSideJoined(PLAYER_2) == false then return end;
		if P2_isSelectingDifficulty == false then
			if param.Name == "left" then
				if characters[tonumber((P2_selectionX-1)..P2_selectionY)] then
					P2_selectionX = P2_selectionX - 1;
					updateSelection(self, false, P2_selectionX, P2_selectionY);
				end;
			elseif param.Name == "right" then
				if characters[tonumber((P2_selectionX+1)..P2_selectionY)] then
					P2_selectionX = P2_selectionX + 1;
					updateSelection(self, false, P2_selectionX, P2_selectionY);
				end;
			elseif param.Name == "down" then
				if characters[tonumber(P2_selectionX..(P2_selectionY+1))] then
					P2_selectionY = P2_selectionY + 1;
					updateSelection(self, false, P2_selectionX, P2_selectionY);
				end;
			elseif param.Name == "up" then
				if characters[tonumber(P2_selectionX..(P2_selectionY-1))] then
					P2_selectionY = P2_selectionY - 1;
					updateSelection(self, false, P2_selectionX, P2_selectionY);
				end;
			elseif param.Name == "start" then
				SOUND:PlayOnce(THEME:GetPathS("","accept"));
				self:GetChild("Portrait"):queuecommand("Selected");
				self:GetChild("DifficultySelect"):playcommand("Selected");
				self:GetChild("Dim"):queuecommand("Selected");
				self:GetChild("SystemText"):queuecommand("Selected");
				P2_isSelectingDifficulty = true;
			elseif param.Name == "back" then
				SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
			end;
		else
			if param.Name == "back" then
				self:GetChild("DifficultySelect"):playcommand("Unselected");
				self:GetChild("Dim"):queuecommand("Unselected");
				self:GetChild("SystemText"):queuecommand("Unselected");
				self:GetChild("PleaseWait"):playcommand("Unselected");
				P2_isSelectingDifficulty = false;
				P2_isReady = false;
			elseif param.Name == "up" then
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
				if MBSTATE:GetDifficulty(PLAYER_2) > 0 then
					MBSTATE:SetDifficulty(PLAYER_2, MBSTATE:GetDifficulty(PLAYER_2)-1)
				else
					MBSTATE:SetDifficulty(PLAYER_2, 4);
				end;
				--Remember PlayerNumber is 0 indexed, so Player=1 is correct!
				MESSAGEMAN:Broadcast("DifficultyChanged", {Direction=-1,Player=1});
			elseif param.Name == "down" then
				SOUND:PlayOnce(THEME:GetPathS("Common", "value"), true);
				if MBSTATE:GetDifficulty(PLAYER_2) < 4 then
					MBSTATE:SetDifficulty(PLAYER_2, MBSTATE:GetDifficulty(PLAYER_2)+1)
				else
					MBSTATE:SetDifficulty(PLAYER_2, 0);
				end;
				MESSAGEMAN:Broadcast("DifficultyChanged", {Direction=1,Player=1});
			elseif param.Name == "start" then
				if P2_isReady == false then
					SOUND:PlayOnce(THEME:GetPathS("","accept"));
					local chrID = tonumber(P2_selectionX..P2_selectionY)
					MBSTATE:SetCharacter(PLAYER_2,characters[chrID][1]);
					self:GetChild("DifficultySelect"):queuecommand("Finished");
					--If the other player is present, wait for them to select character and difficulty
					if GAMESTATE:IsSideJoined(PLAYER_1) then
						P2_isReady = true;
						--If the other player is ready then we can go to the next screen
						if P1_isReady then
							SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
						else
							self:GetChild("PleaseWait"):playcommand("Waiting");
						end;
					--No need to wait if there's no other player
					else
						SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
					end;
				end;
			end;
		end;
	end;
	LoadActor("P2Cursor")..{
		Name="SelectionIcon";
		InitCommand=cmd(zoom,1.5;SetAllStateDelays,0.05;);
		--[[OnCommand=function(self)
			self:x(xPosition);
			self:y(yPosition);
		end;]]
	};
	LoadActor("p2icon")..{
		Name="icon";
		InitCommand=cmd(zoom,1.5;glowshift;glow,Color("White"););
	};
	
	Def.Sprite{
		Name="PortraitShadow";
		InitCommand=cmd(xy,SCREEN_WIDTH*.75,SCREEN_CENTER_Y;zoom,.75;diffuse,color("0,0,0,0");rotationy,180);
		AnimCommand=cmd(x,SCREEN_WIDTH;diffusealpha,0;decelerate,.4;diffusealpha,.6;x,SCREEN_WIDTH-240;sleep,0;linear,.1;x,SCREEN_WIDTH-270);
	};
	
	Def.Quad{
		Name="Dim";
		InitCommand=cmd(setsize,SCREEN_WIDTH/4,SCREEN_HEIGHT;diffuse,Color("Black");fadeleft,.75;horizalign,right;xy,SCREEN_WIDTH+SCREEN_WIDTH/4,SCREEN_CENTER_Y);
		SelectedCommand=cmd(decelerate,.3;x,SCREEN_WIDTH);
		UnselectedCommand=cmd(decelerate,.3;x,SCREEN_WIDTH+SCREEN_WIDTH*.75);
	};
	Def.Sprite{
		Name="Portrait";
		InitCommand=cmd(xy,SCREEN_WIDTH,SCREEN_CENTER_Y;zoom,.75;rotationy,180);
		AnimCommand=cmd(x,SCREEN_WIDTH;diffusealpha,0;glow,Color("White");decelerate,.4;diffusealpha,1;x,SCREEN_WIDTH-240;glow,color("0,0,0,0"));
		SelectedCommand=cmd(glow,Color("White");linear,.5;glow,color("0,0,0,0"));
	};
	
	LoadActor("../DifficultySelect", PLAYER_2)..{
		Name="DifficultySelect";
	};
	
	Def.ActorFrame{
		Name="PleaseWait";
		InitCommand=cmd(visible,false;xy,SCREEN_WIDTH*.75+100,SCREEN_CENTER_Y);
		WaitingCommand=cmd(visible,true);
		UnselectedCommand=cmd(visible,false);
		Def.Quad{
			InitCommand=cmd(setsize,220,50;diffuse,color("0,0,0,.8");fadeleft,.2;faderight,.2;);
		};
		LoadFont("Common Normal")..{
			Text=THEME:GetString("Common","PleaseWait");
		};
	};
	
	LoadFont("Dialogue Character Names")..{
		Name="Name";
		InitCommand=cmd(y,SCREEN_BOTTOM-75;diffusebottomedge,Color("Purple"));
		AnimCommand=cmd(x,SCREEN_WIDTH;decelerate,.5;diffusealpha,1;x,SCREEN_WIDTH-200);
	};
	
	LoadFont("System")..{
		Name="SystemText";
		Text=THEME:GetString("Common","PressStart");
		InitCommand=cmd(zoom,1.5;vertalign,top;xy,SCREEN_WIDTH*.25,5;shadowcolor,color("#061CE8");shadowlengthy,3;visible,not GAMESTATE:IsSideJoined(PLAYER_1));
		SelectedCommand=cmd(settext,THEME:GetString("Common","PleaseWait"));
		UnselectedCommand=cmd(settext,THEME:GetString("Common","PressStart"));
	};
};

t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,25;diffuse,color("0,0,0,.8");xy,SCREEN_CENTER_X,SCREEN_BOTTOM-20)
	};
	LoadFont("Common Normal")..{
		Text="Welcome to Melty Blood Actress Again Current Code StepMania Edition. Select a character or press start on another controller to join in.";
		InitCommand=cmd(y,SCREEN_BOTTOM-20;horizalign,left);
		OnCommand=function(self)
			self:x(SCREEN_RIGHT);
			self:linear(18);
			self:x(-self:GetWidth());
			self:sleep(1);
			self:queuecommand("On");
		end;
	};
	
	LoadFont("Dialogue Character Names")..{
		Text="Character Select";
		InitCommand=cmd(xy,SCREEN_CENTER_X,50;diffusebottomedge,Color("Orange"));
	};
	
	LoadActor("circle thing")..{
		InitCommand=cmd(zoom,1.3;xy,SCREEN_CENTER_X-150,80;horizalign,right;);
	};
	LoadActor("circle thing")..{
		InitCommand=cmd(zoom,1.3;xy,SCREEN_CENTER_X+150,80;horizalign,right;rotationy,180);
	};
};

--[[t[#t+1] = Def.ActorFrame{
	InitCommand=cmd(Center);
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,150;diffuse,color("0,0,0,.8");fadeleft,.1;faderight,.1;zoomy,0);
		OnCommand=cmd(decelerate,.3;zoomy,1);
	};
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,2;diffuse,Color("White");fadeleft,.1;faderight,.1;);
		OnCommand=cmd(decelerate,.3;addy,-(150/2 - 10))
	};
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,2;diffuse,Color("White");fadeleft,.1;faderight,.1;);
		OnCommand=cmd(decelerate,.3;addy,150/2 - 10);
	};
	
	LoadFont("Common Normal")..{
		Text="< Difficulty: Easy >";
		InitCommand=cmd(addy,-40);
	};
	LoadFont("Common Normal")..{
		Text="Start game!";
		InitCommand=cmd(addy,0);
	};
	LoadFont("Common Normal")..{
		Text="Cancel";
		InitCommand=cmd(addy,40);
	};

};]]
return t;